#QSUB -s /bin/csh
##QSUB -q normal
#QSUB -l mpp_p=49
#QSUB -l mpp_t=1200
#QSUB -me
#QSUB -eo
#QSUB -nr
#QSUB -x

cd $QSUB_WORKDIR

##################################################
# Set the environment variables required by code
##################################################

#-------------------------------------------------
# Home directory on host machine.  
# CASEDIR is usually
# sub to this directory.  Below assumes are in
# $HOME_DIR/$CASEDIR and $CASEDIR is single dir
# not a path.  If these are not the case, set
# HOME_DIR by hand. e.g.
# setenv HOME_DIR /paci/ucob/ux450250
# setenv CASEDIR Peentrative/S=0.5
#-------------------------------------------------
set tmphome = `pwd`
setenv HOME_DIR $tmphome:h

#-------------------------------------------------
# Home directory on permanent mass storage for data
# Usually this is the pathname of the top level
# on the mass store e.g.
# setenv PERMANENT_DIR .
#-------------------------------------------------
setenv PERMANENT_DIR $HOME_DIR

#-------------------------------------------------
# Case name -- home directory for case is 
# $HOME_DIR/$CASEDIR on host machine.  Data on mass 
# store resides in $PERMANENT_DIR/$CASEDIR.  Must 
# already exist.
# Normally set this explicitly e.g.
# set CASEDIR Example2
#-------------------------------------------------
setenv CASEDIR $tmphome:t

#-------------------------------------------------
# Number of cpus requested including I/O.  
# NCPU-N_IO_NODES must divide into nz
#-------------------------------------------------
setenv NCPUS 49

#-------------------------------------------------
# Number of I/O nodes
#-------------------------------------------------
setenv N_IO_NODES 1

#-------------------------------------------------
# Pointers to routines that get and put data from 
# local disk to permanent storage
#-------------------------------------------------
setenv RGET $HOME_DIR/$CASEDIR/example_get
setenv RPUT $HOME_DIR/$CASEDIR/example_put

#-------------------------------------------------
# Local disk space used by code for I/O
# Usually set this explicitly too e.g.
# setenv TMPDIR /work/ux450250/$CASEDIR
#-------------------------------------------------
setenv TMPDIR $HOME_DIR/$CASEDIR/TEMP

##################################################
# Run code
##################################################

mkdir -p $TMPDIR

echo "Time at start of job ..."
date
ja

#-------------------------------------------------
# Make sure log files exist
#-------------------------------------------------
$HOME_DIR/$CASEDIR/touch_log

#-------------------------------------------------
# Iterate around (maxcount-1) jobs in case have time
#-------------------------------------------------
set maxcount = 2

set count = 1
while ($count < $maxcount)

if (-e .running) then
#-------------------------------------------------
# Removal of .running means will re-run no matter
# what.  Alternatively, make sleep and resubmit.
#-------------------------------------------------
    rm .running
    echo " >>>> NIC .running removed."
#   set INC = 30
#   goto resub
endif

#-------------------------------------------------
# Get executable from wherever it is; normally
# on mass store so use RGET e.g.
# $RGET $PERMANENT_DIR/Programs/f-plane $TMPDIR/f-plane
#-------------------------------------------------
cp $HOME_DIR/$CASEDIR/f-plane $TMPDIR/f-plane
chmod a+x $TMPDIR/f-plane

#-------------------------------------------------
# Save any previous informative files that exist
#-------------------------------------------------
if (-e precompute) mv precompute precompute.previous.$count

#-------------------------------------------------
# Prepare input
#-------------------------------------------------
cp restart.in input

#-------------------------------------------------
# Run executable
#-------------------------------------------------
mpprun -n $NCPUS $TMPDIR/f-plane

echo " "
echo " >>>> Run $count finishing ... "
echo " "

echo " -------- Precompute -------- "
cat precompute
echo " -------- Precompute -------- "
echo " "
mv precompute list.$count

@ count = $count + 1

end

##################################################
# Job(s) finished.  Chain next if required
##################################################

ja -st

exit
#-------------------------------------------------
# Immediate chaining
#-------------------------------------------------
nsub restart.cmd
exit

#-------------------------------------------------
# Delayed chaining
#-------------------------------------------------
set INC = 15
resub:
set HOUR = `date +%H`
set MIN = `date +%M`

set FIRST = `echo $MIN | awk '{n = substr($1,1,1) ; print n}'`
set SECON = `echo $MIN | awk '{n = substr($1,2,1) ; print n}'`
if ($FIRST == "0") set MIN = $SECON

@ BEF = 60 - $INC
if ($MIN >= $BEF) then
@ MMIN = 60 - $MIN
@ DIF = $INC - $MMIN
@ HOUR = $HOUR + 1
set MIN = $DIF
else
@ MIN = $MIN + $INC
endif

echo " Submitting job to run at time $HOUR"\:"$MIN"


at now+$INC"min" << EOF
nsub restart.cmd
EOF

date

exit

